// -*- c++ -*-

/*
 *
 * Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <gtkmm/selectiondata_private.h>

namespace Gtk
{

SelectionData_WithoutOwnership::SelectionData_WithoutOwnership(GtkSelectionData* gobject)
: SelectionData(gobject, false /* take_copy */)
{
}

SelectionData_WithoutOwnership::~SelectionData_WithoutOwnership()
{
  //Prevent the base class's destructor from free-ing the underlying gobject:
  gobject_ = 0;
}

} //namespace Gtk


