/*
 * Copyright (C) 2020-2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once
#include "shared/source/execution_environment/execution_environment.h"

#include "opencl/source/platform/platform.h"

namespace NEO {
class MockClDevice;
class MockPlatform : public Platform {
  public:
    using Platform::fillGlobalDispatchTable;
    MockPlatform() : MockPlatform(*(new ExecutionEnvironment())) {}
    MockPlatform(ExecutionEnvironment &executionEnvironment) : Platform(executionEnvironment) {}
    bool initializeWithNewDevices();
};

Platform *platform();

Platform *platform(ExecutionEnvironment *executionEnvironment);

void cleanupPlatform(ExecutionEnvironment *executionEnvironment);

Platform *constructPlatform();

Platform *constructPlatform(ExecutionEnvironment *executionEnvironment);

bool initPlatform(std::vector<MockClDevice *> clDeviceVector);

bool initPlatform();
} // namespace NEO
