
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFont.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFont>
#include <QPaintDevice>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFont
  static unsigned int font_const_light () { return (unsigned int) QFont::Light; }
  static unsigned int font_const_normal () { return (unsigned int) QFont::Normal; }
  static unsigned int font_const_demibold () { return (unsigned int) QFont::DemiBold; }
  static unsigned int font_const_bold () { return (unsigned int) QFont::Bold; }
  static unsigned int font_const_black () { return (unsigned int) QFont::Black; }

//  Constructor QFont::QFont()


static void _init_ctor_QFont_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFont> ();
}

static void _call_ctor_QFont_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont *> (new QFont ());
}


//  Constructor QFont::QFont(const QString &family, int pointSize, int weight, bool italic)


static void _init_ctor_QFont_4099 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pointSize", true, "-1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("weight", true, "-1");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("italic", true, "false");
  decl->add_arg<bool > (argspec_3);
  decl->set_return_new<QFont> ();
}

static void _call_ctor_QFont_4099 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  bool arg4 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<QFont *> (new QFont (arg1, arg2, arg3, arg4));
}


//  Constructor QFont::QFont(const QFont &, QPaintDevice *pd)


static void _init_ctor_QFont_3496 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pd");
  decl->add_arg<QPaintDevice * > (argspec_1);
  decl->set_return_new<QFont> ();
}

static void _call_ctor_QFont_3496 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  QPaintDevice *arg2 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  ret.write<QFont *> (new QFont (arg1, arg2));
}


//  Constructor QFont::QFont(const QFont &)


static void _init_ctor_QFont_1801 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return_new<QFont> ();
}

static void _call_ctor_QFont_1801 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<QFont *> (new QFont (arg1));
}


// bool QFont::bold()


static void _init_f_bold_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_bold_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->bold ());
}


// QFont::Capitalization QFont::capitalization()


static void _init_f_capitalization_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Capitalization>::target_type > ();
}

static void _call_f_capitalization_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::Capitalization>::target_type > ((qt_gsi::Converter<QFont::Capitalization>::target_type)qt_gsi::CppToQtAdaptor<QFont::Capitalization>(((QFont *)cls)->capitalization ()));
}


// QString QFont::defaultFamily()


static void _init_f_defaultFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultFamily_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->defaultFamily ());
}


// bool QFont::exactMatch()


static void _init_f_exactMatch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exactMatch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->exactMatch ());
}


// QString QFont::family()


static void _init_f_family_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_family_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->family ());
}


// bool QFont::fixedPitch()


static void _init_f_fixedPitch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fixedPitch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->fixedPitch ());
}


// bool QFont::fromString(const QString &)


static void _init_f_fromString_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_fromString_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QFont *)cls)->fromString (arg1));
}


// Qt::HANDLE QFont::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<Qt::HANDLE > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<Qt::HANDLE > ((Qt::HANDLE)((QFont *)cls)->handle ());
}


// bool QFont::isCopyOf(const QFont &)


static void _init_f_isCopyOf_c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<bool > ((bool)((QFont *)cls)->isCopyOf (arg1));
}


// bool QFont::italic()


static void _init_f_italic_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_italic_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->italic ());
}


// bool QFont::kerning()


static void _init_f_kerning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_kerning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->kerning ());
}


// QString QFont::key()


static void _init_f_key_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_key_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->key ());
}


// QString QFont::lastResortFamily()


static void _init_f_lastResortFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastResortFamily_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->lastResortFamily ());
}


// QString QFont::lastResortFont()


static void _init_f_lastResortFont_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastResortFont_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->lastResortFont ());
}


// double QFont::letterSpacing()


static void _init_f_letterSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_letterSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QFont *)cls)->letterSpacing ());
}


// QFont::SpacingType QFont::letterSpacingType()


static void _init_f_letterSpacingType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::SpacingType>::target_type > ();
}

static void _call_f_letterSpacingType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::SpacingType>::target_type > ((qt_gsi::Converter<QFont::SpacingType>::target_type)qt_gsi::CppToQtAdaptor<QFont::SpacingType>(((QFont *)cls)->letterSpacingType ()));
}


// bool QFont::operator!=(const QFont &)


static void _init_f_operator_excl__eq__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<bool > ((bool)((QFont *)cls)->operator!= (arg1));
}


// bool QFont::operator<(const QFont &)


static void _init_f_operator_lt__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<bool > ((bool)((QFont *)cls)->operator< (arg1));
}


// QFont &QFont::operator=(const QFont &)


static void _init_f_operator_eq__1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<QFont & > ();
}

static void _call_f_operator_eq__1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<QFont & > ((QFont &)((QFont *)cls)->operator= (arg1));
}


// bool QFont::operator==(const QFont &)


static void _init_f_operator_eq__eq__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<bool > ((bool)((QFont *)cls)->operator== (arg1));
}


// bool QFont::overline()


static void _init_f_overline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_overline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->overline ());
}


// int QFont::pixelSize()


static void _init_f_pixelSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pixelSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFont *)cls)->pixelSize ());
}


// int QFont::pointSize()


static void _init_f_pointSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pointSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFont *)cls)->pointSize ());
}


// double QFont::pointSizeF()


static void _init_f_pointSizeF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_pointSizeF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QFont *)cls)->pointSizeF ());
}


// bool QFont::rawMode()


static void _init_f_rawMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_rawMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->rawMode ());
}


// QString QFont::rawName()


static void _init_f_rawName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_rawName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->rawName ());
}


// QFont QFont::resolve(const QFont &)


static void _init_f_resolve_c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_resolve_c1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ret.write<QFont > ((QFont)((QFont *)cls)->resolve (arg1));
}


// void QFont::setBold(bool)


static void _init_f_setBold_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBold_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setBold (arg1);
}


// void QFont::setCapitalization(QFont::Capitalization)


static void _init_f_setCapitalization_2508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QFont::Capitalization>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCapitalization_2508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::Capitalization>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFont::Capitalization>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setCapitalization (qt_gsi::QtToCppAdaptor<QFont::Capitalization>(arg1).cref());
}


// void QFont::setFamily(const QString &)


static void _init_f_setFamily_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFamily_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setFamily (arg1);
}


// void QFont::setFixedPitch(bool)


static void _init_f_setFixedPitch_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedPitch_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setFixedPitch (arg1);
}


// void QFont::setItalic(bool b)


static void _init_f_setItalic_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItalic_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setItalic (arg1);
}


// void QFont::setKerning(bool)


static void _init_f_setKerning_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKerning_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setKerning (arg1);
}


// void QFont::setLetterSpacing(QFont::SpacingType type, double spacing)


static void _init_f_setLetterSpacing_3130 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFont::SpacingType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacing");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLetterSpacing_3130 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::SpacingType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFont::SpacingType>::target_type & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setLetterSpacing (qt_gsi::QtToCppAdaptor<QFont::SpacingType>(arg1).cref(), arg2);
}


// void QFont::setOverline(bool)


static void _init_f_setOverline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverline_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setOverline (arg1);
}


// void QFont::setPixelSize(int)


static void _init_f_setPixelSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPixelSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setPixelSize (arg1);
}


// void QFont::setPointSize(int)


static void _init_f_setPointSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPointSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setPointSize (arg1);
}


// void QFont::setPointSizeF(double)


static void _init_f_setPointSizeF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPointSizeF_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setPointSizeF (arg1);
}


// void QFont::setRawMode(bool)


static void _init_f_setRawMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRawMode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setRawMode (arg1);
}


// void QFont::setRawName(const QString &)


static void _init_f_setRawName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRawName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setRawName (arg1);
}


// void QFont::setStretch(int)


static void _init_f_setStretch_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStretch_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setStretch (arg1);
}


// void QFont::setStrikeOut(bool)


static void _init_f_setStrikeOut_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStrikeOut_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setStrikeOut (arg1);
}


// void QFont::setStyle(QFont::Style style)


static void _init_f_setStyle_1569 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QFont::Style>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1569 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::Style>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFont::Style>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setStyle (qt_gsi::QtToCppAdaptor<QFont::Style>(arg1).cref());
}


// void QFont::setStyleHint(QFont::StyleHint, QFont::StyleStrategy)


static void _init_f_setStyleHint_4284 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QFont::PreferDefault");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStyleHint_4284 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::StyleHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFont::StyleHint>::target_type & >() (args, heap);
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QFont::StyleStrategy>(heap, QFont::PreferDefault), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setStyleHint (qt_gsi::QtToCppAdaptor<QFont::StyleHint>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg2).cref());
}


// void QFont::setStyleStrategy(QFont::StyleStrategy s)


static void _init_f_setStyleStrategy_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleStrategy_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setStyleStrategy (qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg1).cref());
}


// void QFont::setUnderline(bool)


static void _init_f_setUnderline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUnderline_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setUnderline (arg1);
}


// void QFont::setWeight(int)


static void _init_f_setWeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setWeight (arg1);
}


// void QFont::setWordSpacing(double spacing)


static void _init_f_setWordSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWordSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFont *)cls)->setWordSpacing (arg1);
}


// int QFont::stretch()


static void _init_f_stretch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_stretch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFont *)cls)->stretch ());
}


// bool QFont::strikeOut()


static void _init_f_strikeOut_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_strikeOut_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->strikeOut ());
}


// QFont::Style QFont::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Style>::target_type > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::Style>::target_type > ((qt_gsi::Converter<QFont::Style>::target_type)qt_gsi::CppToQtAdaptor<QFont::Style>(((QFont *)cls)->style ()));
}


// QFont::StyleHint QFont::styleHint()


static void _init_f_styleHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleHint>::target_type > ();
}

static void _call_f_styleHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::StyleHint>::target_type > ((qt_gsi::Converter<QFont::StyleHint>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleHint>(((QFont *)cls)->styleHint ()));
}


// QFont::StyleStrategy QFont::styleStrategy()


static void _init_f_styleStrategy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ();
}

static void _call_f_styleStrategy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ((qt_gsi::Converter<QFont::StyleStrategy>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleStrategy>(((QFont *)cls)->styleStrategy ()));
}


// QString QFont::toString()


static void _init_f_toString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFont *)cls)->toString ());
}


// bool QFont::underline()


static void _init_f_underline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_underline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFont *)cls)->underline ());
}


// int QFont::weight()


static void _init_f_weight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_weight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFont *)cls)->weight ());
}


// double QFont::wordSpacing()


static void _init_f_wordSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_wordSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QFont *)cls)->wordSpacing ());
}


// static void QFont::cacheStatistics()


static void _init_f_cacheStatistics_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cacheStatistics_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFont::cacheStatistics ();
}


// static void QFont::cleanup()


static void _init_f_cleanup_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cleanup_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFont::cleanup ();
}


// static void QFont::insertSubstitution(const QString &, const QString &)


static void _init_f_insertSubstitution_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSubstitution_3942 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFont::insertSubstitution (arg1, arg2);
}


// static void QFont::insertSubstitutions(const QString &, const QStringList &)


static void _init_f_insertSubstitutions_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSubstitutions_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFont::insertSubstitutions (arg1, arg2);
}


// static void QFont::removeSubstitution(const QString &)


static void _init_f_removeSubstitution_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSubstitution_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFont::removeSubstitution (arg1);
}


// static QString QFont::substitute(const QString &)


static void _init_f_substitute_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_substitute_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QFont::substitute (arg1));
}


// static QStringList QFont::substitutes(const QString &)


static void _init_f_substitutes_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_substitutes_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStringList > ((QStringList)QFont::substitutes (arg1));
}


// static QStringList QFont::substitutions()


static void _init_f_substitutions_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_substitutions_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QFont::substitutions ());
}



namespace gsi
{

static gsi::Methods methods_QFont () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont()\nThis method creates an object of class QFont.", &_init_ctor_QFont_0, &_call_ctor_QFont_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QString &family, int pointSize, int weight, bool italic)\nThis method creates an object of class QFont.", &_init_ctor_QFont_4099, &_call_ctor_QFont_4099);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QFont &, QPaintDevice *pd)\nThis method creates an object of class QFont.", &_init_ctor_QFont_3496, &_call_ctor_QFont_3496);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QFont &)\nThis method creates an object of class QFont.", &_init_ctor_QFont_1801, &_call_ctor_QFont_1801);
  methods += new qt_gsi::GenericMethod (":bold", "@brief Method bool QFont::bold()\n", true, &_init_f_bold_c0, &_call_f_bold_c0);
  methods += new qt_gsi::GenericMethod (":capitalization", "@brief Method QFont::Capitalization QFont::capitalization()\n", true, &_init_f_capitalization_c0, &_call_f_capitalization_c0);
  methods += new qt_gsi::GenericMethod ("defaultFamily", "@brief Method QString QFont::defaultFamily()\n", true, &_init_f_defaultFamily_c0, &_call_f_defaultFamily_c0);
  methods += new qt_gsi::GenericMethod ("exactMatch", "@brief Method bool QFont::exactMatch()\n", true, &_init_f_exactMatch_c0, &_call_f_exactMatch_c0);
  methods += new qt_gsi::GenericMethod (":family", "@brief Method QString QFont::family()\n", true, &_init_f_family_c0, &_call_f_family_c0);
  methods += new qt_gsi::GenericMethod (":fixedPitch", "@brief Method bool QFont::fixedPitch()\n", true, &_init_f_fixedPitch_c0, &_call_f_fixedPitch_c0);
  methods += new qt_gsi::GenericMethod ("fromString", "@brief Method bool QFont::fromString(const QString &)\n", false, &_init_f_fromString_2025, &_call_f_fromString_2025);
  methods += new qt_gsi::GenericMethod ("handle", "@brief Method Qt::HANDLE QFont::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
  methods += new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QFont::isCopyOf(const QFont &)\n", true, &_init_f_isCopyOf_c1801, &_call_f_isCopyOf_c1801);
  methods += new qt_gsi::GenericMethod (":italic", "@brief Method bool QFont::italic()\n", true, &_init_f_italic_c0, &_call_f_italic_c0);
  methods += new qt_gsi::GenericMethod (":kerning", "@brief Method bool QFont::kerning()\n", true, &_init_f_kerning_c0, &_call_f_kerning_c0);
  methods += new qt_gsi::GenericMethod ("key", "@brief Method QString QFont::key()\n", true, &_init_f_key_c0, &_call_f_key_c0);
  methods += new qt_gsi::GenericMethod ("lastResortFamily", "@brief Method QString QFont::lastResortFamily()\n", true, &_init_f_lastResortFamily_c0, &_call_f_lastResortFamily_c0);
  methods += new qt_gsi::GenericMethod ("lastResortFont", "@brief Method QString QFont::lastResortFont()\n", true, &_init_f_lastResortFont_c0, &_call_f_lastResortFont_c0);
  methods += new qt_gsi::GenericMethod ("letterSpacing", "@brief Method double QFont::letterSpacing()\n", true, &_init_f_letterSpacing_c0, &_call_f_letterSpacing_c0);
  methods += new qt_gsi::GenericMethod ("letterSpacingType", "@brief Method QFont::SpacingType QFont::letterSpacingType()\n", true, &_init_f_letterSpacingType_c0, &_call_f_letterSpacingType_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QFont::operator!=(const QFont &)\n", true, &_init_f_operator_excl__eq__c1801, &_call_f_operator_excl__eq__c1801);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QFont::operator<(const QFont &)\n", true, &_init_f_operator_lt__c1801, &_call_f_operator_lt__c1801);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QFont &QFont::operator=(const QFont &)\n", false, &_init_f_operator_eq__1801, &_call_f_operator_eq__1801);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QFont::operator==(const QFont &)\n", true, &_init_f_operator_eq__eq__c1801, &_call_f_operator_eq__eq__c1801);
  methods += new qt_gsi::GenericMethod (":overline", "@brief Method bool QFont::overline()\n", true, &_init_f_overline_c0, &_call_f_overline_c0);
  methods += new qt_gsi::GenericMethod (":pixelSize", "@brief Method int QFont::pixelSize()\n", true, &_init_f_pixelSize_c0, &_call_f_pixelSize_c0);
  methods += new qt_gsi::GenericMethod (":pointSize", "@brief Method int QFont::pointSize()\n", true, &_init_f_pointSize_c0, &_call_f_pointSize_c0);
  methods += new qt_gsi::GenericMethod (":pointSizeF", "@brief Method double QFont::pointSizeF()\n", true, &_init_f_pointSizeF_c0, &_call_f_pointSizeF_c0);
  methods += new qt_gsi::GenericMethod (":rawMode", "@brief Method bool QFont::rawMode()\n", true, &_init_f_rawMode_c0, &_call_f_rawMode_c0);
  methods += new qt_gsi::GenericMethod (":rawName", "@brief Method QString QFont::rawName()\n", true, &_init_f_rawName_c0, &_call_f_rawName_c0);
  methods += new qt_gsi::GenericMethod ("resolve", "@brief Method QFont QFont::resolve(const QFont &)\n", true, &_init_f_resolve_c1801, &_call_f_resolve_c1801);
  methods += new qt_gsi::GenericMethod ("setBold|bold=", "@brief Method void QFont::setBold(bool)\n", false, &_init_f_setBold_864, &_call_f_setBold_864);
  methods += new qt_gsi::GenericMethod ("setCapitalization|capitalization=", "@brief Method void QFont::setCapitalization(QFont::Capitalization)\n", false, &_init_f_setCapitalization_2508, &_call_f_setCapitalization_2508);
  methods += new qt_gsi::GenericMethod ("setFamily|family=", "@brief Method void QFont::setFamily(const QString &)\n", false, &_init_f_setFamily_2025, &_call_f_setFamily_2025);
  methods += new qt_gsi::GenericMethod ("setFixedPitch|fixedPitch=", "@brief Method void QFont::setFixedPitch(bool)\n", false, &_init_f_setFixedPitch_864, &_call_f_setFixedPitch_864);
  methods += new qt_gsi::GenericMethod ("setItalic|italic=", "@brief Method void QFont::setItalic(bool b)\n", false, &_init_f_setItalic_864, &_call_f_setItalic_864);
  methods += new qt_gsi::GenericMethod ("setKerning|kerning=", "@brief Method void QFont::setKerning(bool)\n", false, &_init_f_setKerning_864, &_call_f_setKerning_864);
  methods += new qt_gsi::GenericMethod ("setLetterSpacing", "@brief Method void QFont::setLetterSpacing(QFont::SpacingType type, double spacing)\n", false, &_init_f_setLetterSpacing_3130, &_call_f_setLetterSpacing_3130);
  methods += new qt_gsi::GenericMethod ("setOverline|overline=", "@brief Method void QFont::setOverline(bool)\n", false, &_init_f_setOverline_864, &_call_f_setOverline_864);
  methods += new qt_gsi::GenericMethod ("setPixelSize|pixelSize=", "@brief Method void QFont::setPixelSize(int)\n", false, &_init_f_setPixelSize_767, &_call_f_setPixelSize_767);
  methods += new qt_gsi::GenericMethod ("setPointSize|pointSize=", "@brief Method void QFont::setPointSize(int)\n", false, &_init_f_setPointSize_767, &_call_f_setPointSize_767);
  methods += new qt_gsi::GenericMethod ("setPointSizeF|pointSizeF=", "@brief Method void QFont::setPointSizeF(double)\n", false, &_init_f_setPointSizeF_1071, &_call_f_setPointSizeF_1071);
  methods += new qt_gsi::GenericMethod ("setRawMode|rawMode=", "@brief Method void QFont::setRawMode(bool)\n", false, &_init_f_setRawMode_864, &_call_f_setRawMode_864);
  methods += new qt_gsi::GenericMethod ("setRawName|rawName=", "@brief Method void QFont::setRawName(const QString &)\n", false, &_init_f_setRawName_2025, &_call_f_setRawName_2025);
  methods += new qt_gsi::GenericMethod ("setStretch|stretch=", "@brief Method void QFont::setStretch(int)\n", false, &_init_f_setStretch_767, &_call_f_setStretch_767);
  methods += new qt_gsi::GenericMethod ("setStrikeOut|strikeOut=", "@brief Method void QFont::setStrikeOut(bool)\n", false, &_init_f_setStrikeOut_864, &_call_f_setStrikeOut_864);
  methods += new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QFont::setStyle(QFont::Style style)\n", false, &_init_f_setStyle_1569, &_call_f_setStyle_1569);
  methods += new qt_gsi::GenericMethod ("setStyleHint", "@brief Method void QFont::setStyleHint(QFont::StyleHint, QFont::StyleStrategy)\n", false, &_init_f_setStyleHint_4284, &_call_f_setStyleHint_4284);
  methods += new qt_gsi::GenericMethod ("setStyleStrategy|styleStrategy=", "@brief Method void QFont::setStyleStrategy(QFont::StyleStrategy s)\n", false, &_init_f_setStyleStrategy_2420, &_call_f_setStyleStrategy_2420);
  methods += new qt_gsi::GenericMethod ("setUnderline|underline=", "@brief Method void QFont::setUnderline(bool)\n", false, &_init_f_setUnderline_864, &_call_f_setUnderline_864);
  methods += new qt_gsi::GenericMethod ("setWeight|weight=", "@brief Method void QFont::setWeight(int)\n", false, &_init_f_setWeight_767, &_call_f_setWeight_767);
  methods += new qt_gsi::GenericMethod ("setWordSpacing|wordSpacing=", "@brief Method void QFont::setWordSpacing(double spacing)\n", false, &_init_f_setWordSpacing_1071, &_call_f_setWordSpacing_1071);
  methods += new qt_gsi::GenericMethod (":stretch", "@brief Method int QFont::stretch()\n", true, &_init_f_stretch_c0, &_call_f_stretch_c0);
  methods += new qt_gsi::GenericMethod (":strikeOut", "@brief Method bool QFont::strikeOut()\n", true, &_init_f_strikeOut_c0, &_call_f_strikeOut_c0);
  methods += new qt_gsi::GenericMethod (":style", "@brief Method QFont::Style QFont::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
  methods += new qt_gsi::GenericMethod (":styleHint", "@brief Method QFont::StyleHint QFont::styleHint()\n", true, &_init_f_styleHint_c0, &_call_f_styleHint_c0);
  methods += new qt_gsi::GenericMethod (":styleStrategy", "@brief Method QFont::StyleStrategy QFont::styleStrategy()\n", true, &_init_f_styleStrategy_c0, &_call_f_styleStrategy_c0);
  methods += new qt_gsi::GenericMethod ("toString|to_s", "@brief Method QString QFont::toString()\n", true, &_init_f_toString_c0, &_call_f_toString_c0);
  methods += new qt_gsi::GenericMethod (":underline", "@brief Method bool QFont::underline()\n", true, &_init_f_underline_c0, &_call_f_underline_c0);
  methods += new qt_gsi::GenericMethod (":weight", "@brief Method int QFont::weight()\n", true, &_init_f_weight_c0, &_call_f_weight_c0);
  methods += new qt_gsi::GenericMethod (":wordSpacing", "@brief Method double QFont::wordSpacing()\n", true, &_init_f_wordSpacing_c0, &_call_f_wordSpacing_c0);
  methods += new qt_gsi::GenericStaticMethod ("cacheStatistics", "@brief Static method void QFont::cacheStatistics()\nThis method is static and can be called without an instance.", &_init_f_cacheStatistics_0, &_call_f_cacheStatistics_0);
  methods += new qt_gsi::GenericStaticMethod ("cleanup", "@brief Static method void QFont::cleanup()\nThis method is static and can be called without an instance.", &_init_f_cleanup_0, &_call_f_cleanup_0);
  methods += new qt_gsi::GenericStaticMethod ("insertSubstitution", "@brief Static method void QFont::insertSubstitution(const QString &, const QString &)\nThis method is static and can be called without an instance.", &_init_f_insertSubstitution_3942, &_call_f_insertSubstitution_3942);
  methods += new qt_gsi::GenericStaticMethod ("insertSubstitutions", "@brief Static method void QFont::insertSubstitutions(const QString &, const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_insertSubstitutions_4354, &_call_f_insertSubstitutions_4354);
  methods += new qt_gsi::GenericStaticMethod ("removeSubstitution", "@brief Static method void QFont::removeSubstitution(const QString &)\nThis method is static and can be called without an instance.", &_init_f_removeSubstitution_2025, &_call_f_removeSubstitution_2025);
  methods += new qt_gsi::GenericStaticMethod ("substitute", "@brief Static method QString QFont::substitute(const QString &)\nThis method is static and can be called without an instance.", &_init_f_substitute_2025, &_call_f_substitute_2025);
  methods += new qt_gsi::GenericStaticMethod ("substitutes", "@brief Static method QStringList QFont::substitutes(const QString &)\nThis method is static and can be called without an instance.", &_init_f_substitutes_2025, &_call_f_substitutes_2025);
  methods += new qt_gsi::GenericStaticMethod ("substitutions", "@brief Static method QStringList QFont::substitutions()\nThis method is static and can be called without an instance.", &_init_f_substitutions_0, &_call_f_substitutions_0);
  return methods;
}

gsi::Class<QFont> decl_QFont ("QtGui", "QFont",
  gsi::method("Light", &font_const_light, "@brief Font weight constant 'QFont::Light'.") +
  gsi::method("Normal", &font_const_normal, "@brief Font weight constant 'QFont::Normal'.") +
  gsi::method("DemiBold", &font_const_demibold, "@brief Font weight constant 'QFont::DemiBold'.") +
  gsi::method("Bold", &font_const_bold, "@brief Font weight constant 'QFont::Bold'.") +
  gsi::method("Black", &font_const_black, "@brief Font weight constant 'QFont::Black'.")
+
  methods_QFont (),
  "@qt\n@brief Binding of QFont");


GSI_QTGUI_PUBLIC gsi::Class<QFont> &qtdecl_QFont () { return decl_QFont; }

}


//  Implementation of the enum wrapper class for QFont::Capitalization
namespace qt_gsi
{

static gsi::Enum<QFont::Capitalization> decl_QFont_Capitalization_Enum ("QtGui", "QFont_Capitalization",
    gsi::enum_const ("MixedCase", QFont::MixedCase, "@brief Enum constant QFont::MixedCase") +
    gsi::enum_const ("AllUppercase", QFont::AllUppercase, "@brief Enum constant QFont::AllUppercase") +
    gsi::enum_const ("AllLowercase", QFont::AllLowercase, "@brief Enum constant QFont::AllLowercase") +
    gsi::enum_const ("SmallCaps", QFont::SmallCaps, "@brief Enum constant QFont::SmallCaps") +
    gsi::enum_const ("Capitalize", QFont::Capitalize, "@brief Enum constant QFont::Capitalize"),
  "@qt\n@brief This class represents the QFont::Capitalization enum");

static gsi::QFlagsClass<QFont::Capitalization > decl_QFont_Capitalization_Enums ("QtGui", "QFont_QFlags_Capitalization",
  "@qt\n@brief This class represents the QFlags<QFont::Capitalization> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_Capitalization_Enum_in_parent (decl_QFont_Capitalization_Enum.defs ());
static gsi::ClassExt<QFont> decl_QFont_Capitalization_Enum_as_child (decl_QFont_Capitalization_Enum, "Capitalization");
static gsi::ClassExt<QFont> decl_QFont_Capitalization_Enums_as_child (decl_QFont_Capitalization_Enums, "QFlags_Capitalization");

}


//  Implementation of the enum wrapper class for QFont::SpacingType
namespace qt_gsi
{

static gsi::Enum<QFont::SpacingType> decl_QFont_SpacingType_Enum ("QtGui", "QFont_SpacingType",
    gsi::enum_const ("PercentageSpacing", QFont::PercentageSpacing, "@brief Enum constant QFont::PercentageSpacing") +
    gsi::enum_const ("AbsoluteSpacing", QFont::AbsoluteSpacing, "@brief Enum constant QFont::AbsoluteSpacing"),
  "@qt\n@brief This class represents the QFont::SpacingType enum");

static gsi::QFlagsClass<QFont::SpacingType > decl_QFont_SpacingType_Enums ("QtGui", "QFont_QFlags_SpacingType",
  "@qt\n@brief This class represents the QFlags<QFont::SpacingType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_SpacingType_Enum_in_parent (decl_QFont_SpacingType_Enum.defs ());
static gsi::ClassExt<QFont> decl_QFont_SpacingType_Enum_as_child (decl_QFont_SpacingType_Enum, "SpacingType");
static gsi::ClassExt<QFont> decl_QFont_SpacingType_Enums_as_child (decl_QFont_SpacingType_Enums, "QFlags_SpacingType");

}


//  Implementation of the enum wrapper class for QFont::Style
namespace qt_gsi
{

static gsi::Enum<QFont::Style> decl_QFont_Style_Enum ("QtGui", "QFont_Style",
    gsi::enum_const ("StyleNormal", QFont::StyleNormal, "@brief Enum constant QFont::StyleNormal") +
    gsi::enum_const ("StyleItalic", QFont::StyleItalic, "@brief Enum constant QFont::StyleItalic") +
    gsi::enum_const ("StyleOblique", QFont::StyleOblique, "@brief Enum constant QFont::StyleOblique"),
  "@qt\n@brief This class represents the QFont::Style enum");

static gsi::QFlagsClass<QFont::Style > decl_QFont_Style_Enums ("QtGui", "QFont_QFlags_Style",
  "@qt\n@brief This class represents the QFlags<QFont::Style> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_Style_Enum_in_parent (decl_QFont_Style_Enum.defs ());
static gsi::ClassExt<QFont> decl_QFont_Style_Enum_as_child (decl_QFont_Style_Enum, "Style");
static gsi::ClassExt<QFont> decl_QFont_Style_Enums_as_child (decl_QFont_Style_Enums, "QFlags_Style");

}


//  Implementation of the enum wrapper class for QFont::StyleHint
namespace qt_gsi
{

static gsi::Enum<QFont::StyleHint> decl_QFont_StyleHint_Enum ("QtGui", "QFont_StyleHint",
    gsi::enum_const ("Helvetica", QFont::Helvetica, "@brief Enum constant QFont::Helvetica") +
    gsi::enum_const ("SansSerif", QFont::SansSerif, "@brief Enum constant QFont::SansSerif") +
    gsi::enum_const ("Times", QFont::Times, "@brief Enum constant QFont::Times") +
    gsi::enum_const ("Serif", QFont::Serif, "@brief Enum constant QFont::Serif") +
    gsi::enum_const ("Courier", QFont::Courier, "@brief Enum constant QFont::Courier") +
    gsi::enum_const ("TypeWriter", QFont::TypeWriter, "@brief Enum constant QFont::TypeWriter") +
    gsi::enum_const ("OldEnglish", QFont::OldEnglish, "@brief Enum constant QFont::OldEnglish") +
    gsi::enum_const ("Decorative", QFont::Decorative, "@brief Enum constant QFont::Decorative") +
    gsi::enum_const ("System", QFont::System, "@brief Enum constant QFont::System") +
    gsi::enum_const ("AnyStyle", QFont::AnyStyle, "@brief Enum constant QFont::AnyStyle"),
  "@qt\n@brief This class represents the QFont::StyleHint enum");

static gsi::QFlagsClass<QFont::StyleHint > decl_QFont_StyleHint_Enums ("QtGui", "QFont_QFlags_StyleHint",
  "@qt\n@brief This class represents the QFlags<QFont::StyleHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_StyleHint_Enum_in_parent (decl_QFont_StyleHint_Enum.defs ());
static gsi::ClassExt<QFont> decl_QFont_StyleHint_Enum_as_child (decl_QFont_StyleHint_Enum, "StyleHint");
static gsi::ClassExt<QFont> decl_QFont_StyleHint_Enums_as_child (decl_QFont_StyleHint_Enums, "QFlags_StyleHint");

}


//  Implementation of the enum wrapper class for QFont::StyleStrategy
namespace qt_gsi
{

static gsi::Enum<QFont::StyleStrategy> decl_QFont_StyleStrategy_Enum ("QtGui", "QFont_StyleStrategy",
    gsi::enum_const ("PreferDefault", QFont::PreferDefault, "@brief Enum constant QFont::PreferDefault") +
    gsi::enum_const ("PreferBitmap", QFont::PreferBitmap, "@brief Enum constant QFont::PreferBitmap") +
    gsi::enum_const ("PreferDevice", QFont::PreferDevice, "@brief Enum constant QFont::PreferDevice") +
    gsi::enum_const ("PreferOutline", QFont::PreferOutline, "@brief Enum constant QFont::PreferOutline") +
    gsi::enum_const ("ForceOutline", QFont::ForceOutline, "@brief Enum constant QFont::ForceOutline") +
    gsi::enum_const ("PreferMatch", QFont::PreferMatch, "@brief Enum constant QFont::PreferMatch") +
    gsi::enum_const ("PreferQuality", QFont::PreferQuality, "@brief Enum constant QFont::PreferQuality") +
    gsi::enum_const ("PreferAntialias", QFont::PreferAntialias, "@brief Enum constant QFont::PreferAntialias") +
    gsi::enum_const ("NoAntialias", QFont::NoAntialias, "@brief Enum constant QFont::NoAntialias") +
    gsi::enum_const ("OpenGLCompatible", QFont::OpenGLCompatible, "@brief Enum constant QFont::OpenGLCompatible") +
    gsi::enum_const ("NoFontMerging", QFont::NoFontMerging, "@brief Enum constant QFont::NoFontMerging"),
  "@qt\n@brief This class represents the QFont::StyleStrategy enum");

static gsi::QFlagsClass<QFont::StyleStrategy > decl_QFont_StyleStrategy_Enums ("QtGui", "QFont_QFlags_StyleStrategy",
  "@qt\n@brief This class represents the QFlags<QFont::StyleStrategy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_StyleStrategy_Enum_in_parent (decl_QFont_StyleStrategy_Enum.defs ());
static gsi::ClassExt<QFont> decl_QFont_StyleStrategy_Enum_as_child (decl_QFont_StyleStrategy_Enum, "StyleStrategy");
static gsi::ClassExt<QFont> decl_QFont_StyleStrategy_Enums_as_child (decl_QFont_StyleStrategy_Enums, "QFlags_StyleStrategy");

}

