/* ----- encode/857x1723, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857x1723_checksums[] = {
  "a2c1b7ffa60681087da6204f1669281950ae2bce4bfd23b3f34ee7464c298aa9",
  "e6c3186f85c9ee4f61bc3ec2f12f5cab699b269f414ceb8125753b5ff3526919",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857x1723_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857x1723_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857x1723_ITEMBYTES

static void *storage_encode_857x1723_s;
static unsigned char *test_encode_857x1723_s;
static void *storage_encode_857x1723_x;
static unsigned char *test_encode_857x1723_x;
static void *storage_encode_857x1723_s2;
static unsigned char *test_encode_857x1723_s2;
static void *storage_encode_857x1723_x2;
static unsigned char *test_encode_857x1723_x2;

#define precomputed_encode_857x1723_NUM 4

static const unsigned char precomputed_encode_857x1723_s[precomputed_encode_857x1723_NUM][crypto_encode_STRBYTES] = {
  {77,130,166,189,46,150,246,244,138,18,73,254,59,101,231,69,20,27,74,194,32,149,7,195,7,70,185,200,162,89,54,65,78,17,114,203,35,157,231,185,147,253,194,49,246,246,110,141,243,138,83,214,194,245,141,58,154,33,86,9,127,153,29,41,255,43,198,75,25,235,134,207,239,62,69,131,248,110,134,133,5,87,84,35,207,25,15,39,210,52,149,72,239,201,254,211,88,138,7,132,166,70,40,20,180,93,148,95,103,11,171,197,109,236,112,83,175,106,97,22,130,235,90,139,206,218,71,245,0,166,189,158,70,97,154,205,123,142,56,152,220,130,32,124,50,47,155,113,183,160,44,34,29,38,144,33,158,58,20,70,227,25,231,84,157,175,140,104,174,65,255,111,117,93,43,202,7,109,205,40,226,116,244,96,141,249,87,30,229,68,102,36,77,192,242,143,88,89,85,154,143,106,96,97,137,195,238,126,93,240,105,231,83,62,247,162,95,56,193,97,20,224,212,22,125,162,151,233,1,141,169,169,87,228,84,8,19,240,173,151,96,194,99,70,214,94,31,19,169,95,164,191,241,5,28,177,222,231,162,229,81,6,138,184,233,61,105,225,191,138,149,32,252,223,253,80,85,82,88,209,40,250,129,251,152,246,22,198,200,22,95,226,8,196,72,216,43,148,222,230,5,57,130,164,202,142,85,37,239,242,1,137,92,40,213,179,201,28,206,169,82,8,70,85,242,223,84,122,169,208,47,248,217,137,63,96,49,22,138,50,194,208,52,244,62,252,163,138,162,251,255,231,192,121,237,172,125,137,34,229,39,214,56,155,61,25,16,84,178,241,199,76,55,36,70,245,124,243,152,78,100,176,148,46,21,125,170,153,139,85,8,243,186,159,124,32,130,238,34,123,22,227,120,11,87,236,198,146,59,153,233,66,83,242,117,153,226,206,5,239,154,250,239,144,94,192,205,245,129,175,226,58,75,66,147,152,72,176,29,221,19,82,61,197,241,238,22,213,137,69,82,23,13,184,180,232,67,198,81,207,23,45,155,79,68,227,9,193,115,171,181,202,53,156,163,145,53,222,219,203,39,49,57,19,26,113,90,223,22,203,92,159,39,164,20,52,74,16,2,104,21,139,185,201,22,70,98,5,237,156,174,70,210,167,76,215,242,196,94,129,210,41,83,58,227,144,69,42,66,76,87,101,137,53,38,54,107,132,162,53,129,209,231,133,162,115,139,216,180,197,86,17,4,22,186,177,52,153,123,92,160,189,106,245,30,211,10,159,94,47,106,153,178,136,240,208,71,230,196,73,192,169,20,181,3,141,13,113,250,94,29,62,92,66,135,182,156,84,80,46,48,164,151,10,168,163,69,239,231,187,21,165,166,99,6,61,66,171,116,75,129,105,188,182,111,164,135,170,223,141,30,50,141,123,29,173,223,232,194,86,165,189,186,26,230,43,109,194,35,241,76,182,251,118,178,190,142,54,252,242,66,206,43,185,31,81,116,232,252,131,222,118,176,184,207,229,71,79,70,211,58,218,159,58,42,230,189,244,35,150,158,0,85,119,244,79,125,137,167,144,21,28,100,5,194,143,14,20,154,179,254,52,82,168,0,192,215,173,131,206,33,161,26,30,127,193,185,166,176,236,81,170,255,208,6,154,155,76,239,62,106,142,115,12,3,92,107,228,28,13,44,22,129,198,253,4,73,97,216,15,247,171,218,154,11,219,169,222,45,117,141,228,163,226,170,176,19,82,86,231,204,179,78,190,30,44,172,42,41,177,238,12,189,60,191,73,207,15,192,206,20,222,110,145,200,17,4,89,105,202,135,207,14,1,248,195,146,193,90,48,16,196,182,55,13,187,193,176,3,219,122,194,202,205,38,228,64,108,130,169,133,64,22,8,95,212,46,222,126,71,230,19,60,84,46,118,202,94,85,52,236,229,98,45,182,0,49,54,180,106,96,24,151,240,113,224,198,107,34,78,194,136,199,36,208,41,174,217,59,189,88,9,31,16,120,217,123,82,160,145,125,11,97,45,250,33,78,239,238,142,85,141,28,220,117,168,64,53,60,241,243,169,51,185,245,65,119,179,220,96,163,5,176,226,60,110,99,120,204,169,161,39,151,45,223,252,225,26,189,239,10,21,32,183,72,129,197,93,211,107,249,51,24,93,18,157,48,154,207,109,84,67,106,15,204,202,93,67,94,213,174,69,68,222,70,47,252,171,216,221,21,222,71,235,77,224,152,75,233,42,150,162,44,116,229,203,29,138,225,119,221,118,137,215,145,90,77,233,64,23,9,168,206,100,52,198,131,163,171,59,228,58,135,255,161,119,115,5,136,16,226,202,27,34,42,197,53,158,7,114,111,1,67,130,148,219,183,136,112,144,208,248,111,91,231,107,148,44,169,226,84,122,186,168,164,5,15,14,17,189,153,168,160,42,178,10,229,209,148,116,237,169,82,131,189,175,93,93,79,164,39,130,236,4,86,45,76,93,144,182,20,87,13,126,218,117,198,120,247,239,162,201,26,236,0,132,10,172,239,19,69,9,244,151,182,54,100,150,125,243,153,202,50,187,140,178,132,120,69,135,125,117},
  {45,22,198,186,229,248,19,201,146,71,89,8,141,159,60,204,91,235,29,225,68,36,12,12,5,154,105,232,148,125,173,61,167,100,224,196,121,113,0,128,170,5,129,248,177,221,4,129,54,36,104,56,193,60,180,91,179,187,217,216,237,107,186,18,59,175,129,185,249,52,149,2,114,46,168,39,90,85,138,83,86,108,62,196,193,16,53,198,30,71,77,112,43,162,3,236,17,189,223,197,164,122,20,199,68,169,209,74,68,149,105,231,77,111,133,227,240,154,246,69,43,44,188,87,72,111,3,130,179,125,115,41,250,242,1,76,248,167,51,183,222,239,68,49,1,91,149,223,204,210,183,57,45,143,70,164,8,179,30,206,62,95,202,39,56,178,238,203,198,118,254,64,163,214,207,1,242,208,126,249,249,154,22,30,60,203,20,147,30,150,136,0,151,119,202,207,40,69,249,49,18,234,79,102,102,162,141,235,113,85,143,28,19,81,216,139,31,197,215,239,153,235,109,116,117,173,146,181,99,74,210,35,68,50,116,91,36,203,123,68,99,180,205,231,155,90,136,221,72,119,91,5,185,65,22,18,201,79,232,35,210,125,166,181,226,127,184,125,239,190,94,139,183,30,75,142,170,202,34,193,45,190,192,190,92,220,120,121,193,131,111,183,153,187,50,131,229,170,219,145,101,204,121,5,134,158,39,91,59,187,120,201,7,253,156,169,19,168,193,103,95,69,131,2,32,56,241,127,70,195,88,76,215,21,112,27,74,227,134,172,153,194,209,100,126,179,42,197,249,70,128,188,214,37,222,154,173,123,251,4,14,110,141,46,157,226,2,255,28,162,144,57,68,77,97,75,163,156,3,111,19,33,123,232,86,63,161,64,32,71,239,228,65,163,183,137,170,189,93,244,113,75,36,238,137,56,214,74,146,111,194,241,160,186,90,36,50,159,64,19,65,14,39,7,152,100,181,244,30,147,123,215,126,223,201,66,76,129,149,151,19,134,180,180,130,39,19,42,183,106,35,58,14,201,55,220,121,94,236,94,231,207,97,103,236,40,88,155,188,242,51,165,36,47,156,238,98,190,132,15,46,22,82,201,109,132,167,7,35,134,28,110,152,7,22,155,206,99,169,230,131,20,204,1,20,44,131,205,91,50,206,205,80,21,56,161,187,176,7,187,15,119,106,251,210,27,41,63,52,176,132,232,105,185,107,114,194,194,236,4,189,131,117,111,96,69,177,176,153,205,95,167,127,199,48,244,252,75,10,3,169,225,55,77,0,144,4,150,225,181,90,178,243,173,224,186,18,235,117,80,142,177,255,230,94,82,252,214,2,225,151,113,188,159,50,41,35,150,166,29,83,189,49,45,52,129,14,165,57,116,184,190,12,222,37,138,126,251,3,108,157,33,202,151,231,70,11,218,84,118,139,62,53,194,165,160,70,149,163,235,106,245,128,86,124,140,191,248,65,70,244,206,147,4,86,177,222,146,63,25,124,255,72,221,46,197,92,184,188,131,32,133,95,255,82,188,215,78,55,87,140,174,97,255,66,231,182,212,127,212,98,233,64,199,79,135,47,225,227,225,15,93,203,66,148,244,181,160,97,69,54,104,96,145,233,146,81,183,197,156,22,231,179,186,203,5,56,51,75,136,183,220,71,244,213,91,115,112,220,60,57,36,187,15,74,129,14,187,36,72,137,2,143,240,41,90,195,159,46,148,143,197,102,59,215,203,33,101,133,154,14,8,5,27,154,115,232,4,148,150,207,41,120,118,54,255,195,252,102,169,146,67,160,105,170,71,148,47,153,169,43,56,230,61,179,115,230,59,172,230,244,4,30,193,252,197,86,180,90,124,248,43,63,189,200,109,40,182,197,30,224,106,161,45,248,167,128,7,49,130,150,202,194,54,25,98,52,17,61,207,183,69,22,243,23,239,138,247,211,15,222,94,113,120,101,188,67,38,72,7,13,141,133,151,224,127,185,33,177,180,77,147,25,70,24,76,226,127,144,184,158,33,95,248,205,217,107,243,199,122,27,40,122,206,243,0,242,173,175,101,121,114,81,14,68,119,160,212,220,171,36,244,143,71,169,187,182,109,112,252,255,201,63,221,30,171,228,248,140,95,45,71,104,191,116,151,16,46,218,191,16,77,190,151,72,144,24,247,168,162,107,6,210,11,160,42,227,51,248,224,2,219,92,231,247,85,230,89,5,81,15,229,240,22,156,206,108,8,97,85,75,112,183,50,204,86,151,93,48,54,182,164,100,50,80,100,240,64,215,253,66,12,83,2,156,120,135,25,71,134,178,103,250,246,136,229,222,232,181,185,9,142,60,107,228,124,5,215,195,228,206,122,95,206,21,67,129,62,95,214,39,238,69,224,72,119,48,174,23,254,85,252,52,14,131,182,55,181,218,79,210,7,104,202,203,240,233,210,120,18,82,106,73,161,177,91,10,114,210,57,125,150,163,53,234,208,110,151,133,87,255,178,78,75,166,148,165,200,242,171,179,240,250,253,54,134,134,70,83,92,230,195,58,34,160,209,91,66,90,122,147,131,38,23,114,96,109,43,37,200,69,180,99,178,203,193,50,144,73,101,92,243},
  {43,64,76,129,244,247,53,121,50,127,20,157,90,197,125,251,14,81,27,252,255,204,55,158,220,14,238,194,93,129,60,30,230,201,150,106,125,148,250,118,251,222,178,171,52,212,65,197,101,117,231,134,208,236,228,118,169,38,185,143,88,209,253,58,63,210,143,11,180,246,221,227,74,16,78,162,8,28,35,212,38,140,90,51,8,127,55,27,112,107,70,58,47,216,12,164,113,44,77,196,63,163,162,3,232,225,247,188,106,47,232,152,49,145,34,224,152,240,0,187,185,49,114,170,30,113,162,232,40,119,106,235,46,86,175,8,11,73,28,214,234,24,80,73,163,186,99,137,18,97,27,208,157,165,247,96,179,236,44,0,45,4,30,130,147,11,129,165,242,231,224,210,33,233,59,13,153,56,128,92,154,15,135,207,120,111,114,146,247,164,19,157,46,248,33,37,17,7,216,215,122,32,35,129,113,222,109,0,118,131,0,87,74,28,131,235,0,120,132,216,87,23,182,174,88,110,199,130,27,154,128,110,236,162,158,102,48,42,105,23,163,47,197,37,215,180,159,207,237,103,18,177,184,27,89,195,154,193,178,6,70,58,127,50,225,204,145,132,59,167,225,227,153,118,119,231,114,179,215,209,156,110,175,149,188,216,55,248,90,43,148,152,46,57,188,127,194,43,176,228,151,226,185,86,58,111,81,221,101,170,199,105,75,98,217,127,198,23,207,140,58,110,237,200,255,240,200,137,224,179,65,56,129,162,235,226,90,188,126,109,120,207,223,6,150,173,137,222,235,120,239,199,119,244,151,112,111,98,68,240,59,183,162,239,148,243,204,209,13,236,21,82,234,4,1,59,201,31,185,54,36,88,230,77,217,124,138,6,49,6,18,63,54,38,238,166,96,250,50,13,172,206,213,200,72,56,243,104,3,158,94,162,4,19,1,30,41,52,226,135,53,105,74,82,111,37,175,203,152,41,92,222,123,16,229,16,126,183,17,165,213,129,56,91,166,26,113,199,21,2,163,54,211,195,71,96,113,158,96,27,63,219,79,136,88,9,158,88,60,223,148,121,170,228,116,51,138,173,23,90,213,235,62,210,136,101,207,66,123,143,117,208,181,250,202,233,135,193,236,217,22,161,4,253,183,163,161,153,0,38,230,35,71,21,35,41,10,110,247,192,154,109,81,174,74,199,90,93,130,87,62,180,43,173,109,211,118,68,73,73,185,242,111,190,31,121,20,231,203,211,243,86,194,163,187,208,85,29,118,215,9,124,250,11,90,164,203,27,91,150,218,123,102,110,52,152,30,247,84,201,157,97,186,147,109,58,71,7,173,200,132,216,81,205,77,62,74,187,162,113,25,6,255,158,73,127,171,74,234,165,183,55,158,222,16,132,229,153,249,190,144,25,208,207,11,71,47,12,21,10,239,23,82,20,1,10,250,97,35,253,199,142,30,8,7,35,209,172,43,4,191,182,231,69,112,37,232,0,170,91,46,176,101,188,192,229,152,124,1,63,171,163,226,246,58,174,139,68,184,145,208,215,12,255,135,113,246,17,123,40,125,154,155,98,8,19,66,231,28,230,131,74,171,175,104,67,174,139,50,60,71,173,156,16,16,147,201,117,226,165,247,91,155,6,0,209,14,118,99,223,61,229,230,115,155,83,167,198,41,155,78,218,126,7,175,28,167,31,17,34,175,184,210,226,107,198,6,109,255,8,240,120,105,154,40,62,215,133,227,213,132,209,49,10,70,184,58,186,147,152,102,142,180,17,98,139,145,41,114,60,222,55,46,43,203,163,90,39,190,59,91,0,162,53,48,188,89,93,107,159,21,17,234,49,111,0,223,188,170,133,92,171,116,172,68,133,228,155,25,43,125,161,214,207,71,238,1,108,138,80,160,57,221,74,194,71,159,233,209,95,169,16,233,21,105,249,249,3,16,6,211,180,39,71,130,229,102,199,125,113,142,159,79,161,60,237,225,168,212,25,90,11,87,101,197,28,112,111,8,85,131,44,115,91,14,113,170,184,235,44,67,201,212,187,215,51,63,3,217,207,137,137,5,70,81,53,152,147,106,174,238,93,123,88,182,86,159,239,0,26,197,127,234,133,201,224,123,173,235,45,231,239,210,182,86,28,216,19,188,178,43,27,195,230,186,208,87,255,155,248,169,221,230,105,241,31,116,182,46,171,36,105,181,99,140,182,101,233,54,215,15,136,169,222,102,81,125,252,255,175,74,108,205,176,180,199,118,199,15,126,113,32,108,3,221,123,11,74,235,19,96,217,47,143,118,129,28,192,192,209,91,97,160,153,254,145,161,188,250,1,243,182,167,165,185,152,84,1,69,181,31,13,187,47,83,242,157,90,201,117,57,245,172,226,185,174,9,126,12,26,103,88,202,66,18,68,246,220,155,107,59,85,146,2,201,239,211,75,254,219,79,223,8,186,185,48,54,89,88,207,195,152,136,123,50,170,70,248,13,53,42,86,148,196,228,2,118,2,185,180,181,34,95,102,22,22,164,136,163,41,91,70,10,206,163,81,223,235,242,188,136,55,46,14,222,39,233,144,223,172,29,38,200,227,196,54,216,56,44,197,97,60},
  {104,23,70,225,98,32,199,216,163,118,162,208,155,136,26,112,48,133,46,89,211,183,154,238,14,171,120,88,20,99,230,239,126,186,84,178,10,255,76,237,164,225,194,213,12,11,132,149,133,201,118,130,108,102,97,28,47,224,208,140,124,179,0,148,174,163,216,115,59,153,94,248,19,255,170,155,124,209,153,16,84,28,92,130,156,130,240,111,167,227,145,105,58,66,143,98,26,30,229,232,125,148,234,124,95,30,107,19,22,107,56,46,12,29,23,234,139,38,158,72,11,24,56,13,218,78,193,87,17,211,75,8,97,156,134,47,226,27,184,242,30,219,253,251,115,7,7,4,253,27,128,212,224,249,100,44,124,86,219,154,199,61,81,221,82,113,91,10,47,3,43,43,193,226,200,178,63,27,154,0,80,249,170,241,109,95,3,77,172,129,43,221,74,19,71,116,210,230,116,235,121,90,53,252,164,83,193,6,125,207,150,127,104,32,82,243,131,145,67,116,18,25,161,83,59,238,110,94,47,109,152,192,176,48,230,47,105,229,0,137,176,164,45,188,131,151,38,250,143,124,126,201,177,137,199,165,63,89,161,174,29,32,18,65,110,197,110,236,105,116,197,190,209,145,188,194,59,130,131,149,18,136,51,24,144,209,204,209,127,248,170,87,100,92,64,139,207,179,244,144,242,66,46,164,156,81,190,76,24,76,163,245,66,208,14,171,61,77,235,180,238,220,95,17,196,115,200,143,7,160,219,104,117,97,62,147,64,49,245,252,15,79,85,237,48,234,12,138,139,42,195,203,114,54,221,181,156,41,124,51,21,175,90,229,56,23,234,62,93,25,4,235,188,150,157,134,235,157,235,251,75,162,20,30,77,117,118,237,0,2,187,100,109,38,212,224,98,105,96,239,90,25,174,10,248,162,166,195,3,174,183,250,154,53,184,21,217,225,30,7,91,47,137,25,99,95,13,25,23,210,164,86,51,206,172,116,42,239,73,97,135,234,153,134,181,170,201,183,123,18,143,48,220,221,142,198,212,228,179,35,183,216,169,31,51,184,79,167,81,243,183,67,166,43,237,207,64,51,193,14,128,109,97,168,160,87,76,227,114,55,216,93,219,186,41,166,33,9,57,191,243,153,106,11,212,14,191,23,165,146,34,123,217,161,4,94,169,145,69,159,253,107,53,235,148,141,125,179,161,227,227,38,169,80,103,202,224,177,165,183,13,49,89,28,2,143,44,103,71,105,227,58,233,83,96,228,0,38,184,253,145,247,105,64,28,240,157,13,60,168,194,163,3,17,119,15,112,231,125,249,159,50,193,155,220,4,195,227,236,16,73,74,97,244,214,124,196,62,41,129,129,65,176,127,125,21,204,224,247,37,231,249,255,119,212,50,135,219,164,142,159,15,190,225,144,204,180,50,24,27,37,92,88,236,90,54,222,66,164,195,186,97,52,35,184,204,216,231,150,19,59,249,150,22,154,226,132,254,129,209,125,11,121,240,17,34,82,220,141,67,27,200,22,215,128,179,71,155,231,238,17,35,0,63,21,205,167,195,27,11,9,74,90,228,229,5,3,4,162,54,46,154,164,219,4,149,254,230,122,227,140,250,58,35,79,243,50,143,92,189,97,240,172,239,2,158,98,78,240,205,252,226,195,102,65,44,19,247,68,245,226,90,95,61,216,92,196,240,130,27,100,199,88,224,235,72,24,204,161,12,184,54,115,150,189,211,19,6,186,52,255,221,13,24,154,152,119,56,86,241,138,157,135,194,57,248,75,246,154,137,75,66,197,162,113,148,134,139,182,83,116,206,254,226,28,176,138,112,33,65,206,71,84,159,33,201,192,208,231,137,86,17,140,197,249,28,1,72,106,89,73,222,208,154,76,194,219,165,125,172,117,146,93,141,255,6,144,205,104,105,85,180,235,105,229,208,141,26,43,65,219,135,139,78,82,150,190,15,39,165,195,179,43,30,31,50,84,55,84,158,174,135,243,17,134,179,147,194,30,42,213,52,126,38,67,162,12,95,197,20,117,249,54,184,49,0,197,160,70,145,209,101,158,226,124,189,10,36,163,32,93,224,0,234,146,248,11,92,21,150,41,230,218,105,237,171,13,43,121,206,254,192,76,205,49,9,158,189,64,249,174,60,180,238,239,85,136,8,197,196,179,30,235,206,141,74,117,59,224,172,194,188,68,211,170,60,198,26,200,77,214,29,138,159,250,170,254,236,93,137,219,128,75,106,233,127,223,21,44,249,60,191,70,55,60,239,207,78,172,137,86,13,96,196,69,113,86,80,57,92,197,97,60,253,151,101,115,128,157,243,227,175,191,43,104,105,199,131,7,112,235,20,40,23,183,180,181,188,71,198,115,115,252,136,107,175,160,21,244,195,129,11,105,177,218,156,173,39,48,163,180,197,52,231,8,122,149,109,29,136,222,241,191,162,161,190,181,70,234,21,13,108,244,165,24,35,62,205,77,208,47,29,147,124,246,77,23,69,228,133,85,109,190,87,19,236,141,212,17,3,42,224,174,180,152,231,11,152,32,241,113,171,127,178,50,65,136,250,229,187,121,23,169,185,210,3,255,119,142,210,53,180},
} ;

static const int16_t precomputed_encode_857x1723_x[precomputed_encode_857x1723_NUM][crypto_encode_ITEMS] = {
  {-3600,3324,32582,-19626,-22869,-30881,-27216,-1760,26458,-25819,-1974,-24451,-21224,32595,-9676,28684,-15962,9188,9157,19404,23970,-11755,-10850,7375,-16369,13148,3846,-13825,-30869,22739,28747,7392,-20839,-19903,-6691,-5968,14224,7328,10912,28826,-5782,-21481,27327,-10629,12991,-10326,20232,2735,-26869,-123,19355,-13634,-20506,-27386,-27660,-25752,27128,-19726,-4102,12857,-13080,16021,32475,-31169,12534,7728,-9982,-103,-3700,21586,5185,-14231,-3212,3467,-8049,20577,572,-26410,-24760,2304,24263,-10817,-11565,22580,-10698,23096,6815,17687,21234,-19381,-6800,-28496,5896,19118,25996,16310,-5701,-25585,2355,-21849,-27016,17146,10763,-14353,-5155,-11329,-14997,31525,24778,10205,11056,-5213,16247,-23010,-5820,28660,11349,10061,20193,-10358,-4903,5186,14234,25356,-9810,-12813,12201,-13845,5319,13784,16589,-26907,-13226,-24145,-16545,-19857,-1626,21428,-22727,7598,31809,-8853,-468,-32056,5583,23472,-10214,-9382,16686,-7986,8574,-2426,11999,-29050,20943,11451,-119,24851,6293,-17464,12549,24851,280,-10113,-13677,26676,4586,6280,-10814,8523,14118,-29159,-4008,-10569,25351,16894,1311,-4949,-32662,16767,-3290,12598,-17876,10686,-4961,-10970,-8650,7731,8005,343,-24826,17586,9404,-12129,-16635,18371,19412,-31429,-19499,-19509,-24375,13029,16409,-32222,-13252,19337,29072,-28851,26321,-28232,-2564,28457,-15286,-32052,-30617,-7594,-21468,3357,10667,-3458,-19279,7671,1014,14480,4060,-11752,12304,-16668,13192,7648,22477,3674,-13971,21993,4322,-30770,22104,25005,13103,13059,11496,26256,-32535,-4989,4434,-17655,-5175,-5615,30834,-19601,25456,-11506,11654,-18697,-32145,-17204,-6445,-15155,-9304,-5421,-15948,-29983,-23326,-16271,-13193,-29093,-19513,16221,-21398,1920,-13657,4308,-9263,5467,2479,16840,-21225,-25187,-15926,-17259,735,9700,-4730,-9093,-6003,9936,-29060,14333,-12776,5653,-3585,-29998,-93,20543,6544,-19807,-19392,-17573,16219,4948,21699,22573,-12650,-17684,-17664,-26083,-26177,-2,-23747,31039,-7031,-29336,-14835,13086,-30007,28392,-1103,-26504,-7824,9743,-12647,-5972,-30062,11440,-15446,22892,-9106,2910,19780,31135,-11798,16436,28858,-11854,-27417,-15139,21986,-9983,-32215,-3019,25839,12228,3520,-1697,-28322,3591,16616,15652,-32442,-25349,5757,11175,-2879,-19657,-25715,26146,17337,-8282,-25247,-29974,-17274,-22936,4376,-8698,29909,-20179,14203,-8269,15501,-26838,22354,-19119,18115,-8134,-18164,8580,12121,-11093,19470,-31531,9510,26106,-24937,-9800,-20364,-8412,24940,-19760,28541,32260,22071,1405,-6591,30574,-29825,-3974,-8905,2414,-11766,-29932,2464,-6944,-12115,10936,-17992,6734,-11844,-2483,2860,-22555,22084,-30509,-6560,27929,27639,-9132,-32603,20172,27886,-17637,-12995,29332,6711,-7378,-26979,10446,-3298,-29526,-3620,-889,25099,15351,-22983,20711,-4425,-26292,-20633,19050,14336,-7743,7681,23945,6874,-10758,7234,12311,32667,-21234,8681,8772,-25308,-5726,13819,5204,-7359,24277,-32335,21469,23347,-15184,-29754,25419,11508,-15175,6329,-4448,25407,8819,-24530,30496,-15579,11569,-29235,-4354,-21372,24478,14714,12128,-4950,-29912,30475,-6679,-20117,-11275,9316,-30073,32622,-7693,29767,-20457,4135,-19664,-24142,-23335,-10163,127,23834,-16869,-5733,-26771,29690,190,-7974,-20863,-25555,15771,1978,-7882,-20737,6967,-19929,128,-29070,-653,980,9359,-5192,9253,-28377,-25452,8176,-20382,25207,12599,12962,4016,-1474,-2918,-5152,29175,4760,2921,16136,32241,29468,-30547,19886,3398,-11435,-24250,-11006,-926,-22356,-1962,-12784,4608,-29476,21178,-31357,-7645,-32437,8743,30758,-28911,20208,4909,20556,20208,-14667,2147,-13246,-15656,1669,-24013,1101,-28969,-32156,-18707,32634,9489,22336,-10917,-2912,-12735,-18815,-27298,14543,7315,-31574,-4132,-4127,23663,14927,-21475,5469,-28521,28593,-25059,30140,26011,23457,-10177,-19994,15158,-9170,-12220,-7355,-26710,21161,-19694,-9226,-31023,-29456,29845,19558,-28939,-2246,-19714,-12765,12937,2135,-4667,-10467,-4723,-26878,-26881,23000,-32232,-27068,-4052,-10064,-22589,20028,10791,-7010,-22916,-26603,5901,23472,-22409,3534,3911,1302,-28011,-26258,-22296,1012,25610,-24545,25961,21327,14721,-15278,8558,32185,31926,18723,10830,19877,26124,-20375,12529,8646,10710,-27902,24088,30899,-29971,27383,-19357,-20256,-11213,-22800,-22046,-29792,7463,-19017,22248,-12224,-3678,-8943,-17980,13362,-29655,-8220,14401,11101,-7364,4879,2222,-6043,424,8801,12856,20687,16415,23511,-17478,-16328,-10527,32405,4929,-16691,-24817,28081,-13811,12284,-10598,-27910,-32515,-12312,32632,-26974,28050,14527,8583,-14561,-12897,-13693,-6111,17551,19747,-21832,21460,32060,-30142,7477,16140,-11417,2515,-20153,4928,12273,23479,-5865,-17877,6792,6496,-10249,26069,7808,32171,-10797,-4400,16109,-14139,-4865,209,-17105,-21720,-18729,-23901,13714,1247,21588,-18210,-1104,5642,-17775,-20677,-18995,-15190,-22901,-5569,-15946,11855,13925,-21632,-16279,5512,-6949,6904,5336,-16221,-16911,1081,-22692,-25818,-32158,23374,-21500,-5827,30808,29452,-7323,18651,19448,-1038,29003,23779,20575,18607,25946,4885,-1018,-17036,-19522,20214,-3873,-25609,-7872,-22935,-32391,17235,-16299,-26474,-24681,-20105,-23427,-8938,-2221,28375,-9043,9672,20313,9784,27208,-7920,23851,3715,-9175,-11465,-32542,18777,4988,-27511,-26203,22893,-14340,25350,31618,21781,18993,-17047,18510,-12468,14100,-14943,-7671,4521,-17658,-1913,17180,4871,-14816,697,22563,-21890,-7539,13769,20247,17073,-17475,-18164,25849,-11056,22710,-27704,-13148,-25988,-6161,21471,-16032,-25556,22903,-1714,9544},
  {-20875,18207,-5823,-31621,-2849,-5341,21718,25373,2956,-15423,-19747,2042,13555,-25222,-31462,-18886,-19887,31962,26666,28889,-498,7996,-19482,25072,5863,-26297,-3008,-5117,14609,13890,-30351,-26715,-10824,1028,15285,-27168,-17853,-31997,-2714,-30237,14650,-4820,14704,-10550,21997,13643,-23180,19108,24943,-30090,6944,-20060,20925,24342,10503,-4584,29696,-15491,8328,-4110,15198,29031,-14185,31988,10453,-2457,-9207,7872,-20047,-22172,4245,-10806,2296,-2896,31515,-22479,22465,5601,22365,9269,6180,-7294,6062,2831,924,3419,-22949,-6420,1995,-29202,1907,-28248,-10958,26728,-11289,10011,-14473,27111,-30433,5023,3309,27207,13050,17856,30133,-2721,-30656,11184,10539,3545,-6340,-2492,21838,-6713,-9772,-10405,-3293,-20174,19294,-30350,-19788,-30460,2736,-584,31169,27787,-30677,-27514,4896,-21833,31553,7225,-29004,377,26068,681,19316,-25986,23177,-3952,31485,-27345,21950,-8352,8116,-9522,-23546,-25376,-12037,19004,-28188,23197,-6220,-8446,-13111,25559,30543,14982,-13280,-26123,10531,22325,21850,-6477,11118,14009,-16372,-21930,26927,15619,-25265,29096,-32305,25976,-29231,-31864,-28790,-15866,-11491,10045,23328,16352,28322,-974,23313,-28213,-1247,25991,-16389,-10158,32052,-18504,-30196,3470,-5515,-22597,9649,2572,4189,-26435,-8975,8765,-32712,7358,29050,-32582,-21823,-23165,18551,-28104,-9963,-16805,25392,6292,5447,22351,-32585,17155,861,-101,23564,-3290,-6690,-21090,-22246,5408,-32715,-9405,-11661,15261,23362,-11814,-14692,-528,-22736,-1649,10792,-7530,-29960,-6871,23372,11480,9237,-13709,-25703,4150,13603,-3953,-15471,23790,11943,296,25302,22629,-8403,28162,16034,-5762,32259,20516,18858,20503,29880,-23788,-12674,-2613,31531,-25012,23143,9386,-5562,-6654,25052,-6803,11413,15656,-11209,-11878,-25719,23184,-32517,-20247,2876,23966,11275,18106,-25080,-17172,27420,-22720,-10917,-17718,-11032,-15319,12414,-22653,7654,-10589,-1786,-29748,29562,19532,-25729,22221,-23370,14943,-19697,7567,-30862,-32729,-5893,20696,6965,-16523,22339,-9034,-20235,11482,16950,32726,19194,6332,-16230,-15904,-20391,-5958,19776,-8117,-17744,-31262,-24460,17101,20762,14359,-8370,-19566,-27948,13332,22068,-28892,10483,-20948,3488,10460,20899,-11000,-4145,-32284,-12200,13547,12631,-31924,9487,26478,-22934,-7354,8030,1808,-13708,27913,30032,28842,31238,-12436,-20027,30395,-5259,31720,18179,3212,-27437,-24482,-23970,-32203,11555,30172,-404,-1550,-5188,5191,-2469,-17411,27267,5794,20653,15966,14720,11239,17277,-17011,-31842,-5256,-22933,-20257,-12348,-23047,-20641,32748,-5640,19624,-12716,27138,-10356,-28546,6974,-13033,-28308,-10130,2136,13700,-10735,32580,-31406,28867,14873,1408,-19198,-4246,-13805,20350,-2213,5853,-7839,3121,30236,-12899,-45,27124,-26893,-25609,-2876,-8766,2981,29218,-16893,1324,22009,-5511,-28804,21610,-8930,13873,8055,6356,-14297,-28453,24461,-15099,-3779,-24894,27625,-8434,17985,-16374,1063,4720,-5879,11994,-16519,-6156,-20017,-28147,-22332,-30309,9447,-14987,-6292,-10892,-7508,3978,-6205,24479,-22802,12848,899,13620,-5820,319,-31874,7328,-12978,-13720,5468,14266,-13868,21379,21192,13042,79,19311,31005,29770,9524,18023,-5630,-5527,3653,22917,22039,5023,-5743,-32492,31180,31379,-14198,719,28099,9108,7736,-12038,82,2165,-4355,-13130,-2270,21306,-4286,-24452,12119,-12399,17287,-27407,16612,8350,29755,-6967,-2168,-28195,-15140,-4550,-24269,-32557,14522,25202,3431,-10580,13690,-26286,31039,-16067,-26018,-22519,-8,-14349,-13443,-31359,-17500,-13738,-8078,-32680,22645,3939,-30077,23510,-409,25712,8948,5809,-2874,-14288,20965,30555,-9676,-6586,-11344,25157,20313,29581,-24425,700,-1955,-23108,8216,13930,-23731,14211,29127,-12752,-20649,-12303,-31550,-27898,-18751,11138,-30782,29600,10567,-25307,-15358,9745,6158,-4165,8654,-22643,16415,26164,3644,8363,-5816,17035,-19314,26317,-4564,15293,11941,30713,17917,-20053,7896,28451,26894,15021,26026,-20794,20003,-13,-1836,18139,-14762,7131,-960,28302,-30698,16532,13732,28620,-25572,-10021,15197,-8067,-26656,31786,-6953,16000,26639,15538,8268,25226,-31582,-12015,25338,-22733,11735,23267,5497,11321,31552,-31891,-10501,-14605,-26242,-16409,17719,7849,-7666,11123,-5837,9449,-30541,15721,14785,-2694,17228,-17328,-25262,13438,29150,9115,8666,636,-24635,19578,4806,-16035,12044,-27645,13288,26727,-16965,-14636,-20052,13929,19531,8277,17036,7886,17230,27215,29198,25485,-26647,23192,21071,28708,-15373,-20504,14844,8921,13311,10079,-29450,21395,25658,5975,7142,-22130,-567,32296,-6666,22963,-23803,12883,-10709,-25778,-22921,-4265,-17695,-28987,13251,29025,18220,-4688,-15570,-23907,-29152,-7250,-26333,24795,26739,-28825,-9180,32621,26877,8326,8704,7854,13500,3806,-8993,-1375,-12463,-4542,-11458,-29044,-10133,19213,15138,-12294,-22631,21394,-18321,24638,-21197,13399,22409,-26696,4063,26342,-14129,-6891,18860,22367,5826,10983,23766,-26596,19469,21210,-23856,25073,5776,18239,-616,-8915,-30094,11793,19002,9614,26493,27394,20965,1740,-18255,-7478,26892,-26704,11039,-21702,21357,-18908,-10646,31614,-2566,26184,-15689,-18693,-29244,-8508,1801,-18992,-6430,-29608,-17528,-7050,2589,9490,-12091,16341,-22390,13482,11785,-2954,-5440,7100,-19533,7371,13015,-22988,32201,31714,12018,-3759,31952,31469,-27926,6679,-20758,-4716,18985,-29068,-294,21035,-11501,-27819,-30005,-20820,26305,-8670,469,-524,-21580,-18747,-13573,-7757,-7477,9715,4419,-31764,-10743,-1834,-27811,-24572,3121,-7950,-29587,-4634,-19127},
  {-20756,-29307,-24693,25419,-21244,6568,-31582,4892,29727,5986,1461,5412,-3852,986,-11087,-8440,8078,1554,1775,19780,-18163,32177,-12871,10254,6759,21915,24718,-12983,-13181,-1002,10536,15583,-5095,-18888,18156,-13151,-26595,9942,-17859,-16323,-3061,-18356,-25167,-29213,12960,-4907,28858,18678,22441,14630,-7659,-29066,9015,-25186,-26924,31180,-25252,10249,-15177,-9301,21590,22850,28559,15929,-20456,-26174,27770,7196,25129,2129,-12378,25423,-23873,14909,25494,25996,31723,27860,-447,25447,26450,-12939,-28341,28664,14286,32212,18014,-20671,24357,-29967,-14687,20445,-3398,25477,19079,20961,28768,6803,18738,19635,-30723,-9693,-12164,-24739,-26573,-8197,-3372,-29993,-488,29061,8983,8376,31972,19665,28336,3260,-21097,4995,13733,-23532,-8347,-10290,-16515,-27765,31423,-17756,26419,982,11399,3518,6807,-2365,-24055,5812,24573,-21337,-9851,-23729,368,1200,19354,-16835,19837,1369,879,-1165,-7131,-19974,-16097,27309,-3793,-31797,-851,26,-13869,-20485,-14994,17609,10555,-7366,-22625,-673,-19011,7744,-3704,-31316,19946,-20828,18812,-30435,23206,-28630,13625,-5889,-14886,-23682,-20411,20103,-13280,29005,5558,-1265,-9471,14016,-2847,-29620,-25352,16708,32580,-4439,30637,4552,-3294,14604,21908,20697,2125,-13769,30838,18078,-28561,-24815,-12919,1717,-23209,-24764,3808,22644,27110,-2209,2245,5313,-25400,-9059,1685,20457,26354,-29141,-27677,-26126,11416,30313,-8647,-8237,28763,-10705,-18217,-19350,15774,-26029,-20395,-27462,22573,1846,13627,26615,-28707,27187,13048,15012,9420,-17597,-15710,-29505,27044,10749,19158,23411,12214,32435,18207,24791,-22520,-15538,5788,14493,-26680,-3049,-1818,-12126,-21003,-6330,-1461,-18537,-9625,3405,-11573,-15312,16200,28153,-15022,4998,15017,14576,-14063,-19398,-32400,-2842,25887,16629,-1868,17031,-27165,26331,19949,7778,3692,-7079,22896,-31017,16969,14708,-26501,6847,1957,-23926,-3411,8852,-891,23182,-17676,-27697,4351,23244,24790,-8953,-9838,-17316,1618,26896,29941,-7194,29894,30801,13367,-5934,-19821,-32577,20528,-25480,21346,22580,-21626,21960,-25357,-24500,1917,-24927,-11158,18194,-1249,-31135,-3180,-154,-9954,-24084,17200,20520,-16781,21280,23470,25163,-4998,20539,-30780,7145,32513,16163,22606,5133,-9780,-20503,-12550,1145,-3203,-16693,28062,19458,-4568,-11649,-10951,-28539,744,-24172,-22078,29392,-24275,-12460,6049,-24979,-19351,-21388,-13635,-7486,15742,-25411,16452,718,-13440,-20596,32134,-31517,12245,9314,7421,29139,-21247,-25652,-24613,23072,7624,-8691,20552,-26216,-20526,25748,10579,26328,-7632,-10953,-10499,20031,11307,867,-9746,-16452,7362,27463,-902,-18046,15861,-21861,1050,26827,30910,10272,-17025,28674,31501,-29904,-27701,-3997,-23302,29946,5771,-13115,19039,9892,30650,-23662,-28356,-709,25357,-17730,-27000,8732,14330,-30562,-1785,-4729,13721,-25346,-20541,22240,20418,31130,82,17071,-22911,545,-20933,14163,18229,19445,4811,7035,6646,-16406,29760,-10682,13524,-31016,-8491,-15325,-62,239,13119,922,12199,1008,26274,-30421,-27322,26438,14845,31368,2315,-15862,19311,25757,-29999,19036,-29037,22986,14205,-15662,-31813,27620,26264,3968,10185,32478,-8126,-25828,-23874,-22505,-4780,12093,13480,32607,-27796,-20026,-23417,-20359,12672,-27378,-23250,32052,-4134,522,-17319,15321,-10912,17662,-7073,-1818,-12030,32003,-1437,-12751,-111,-8761,8989,-25813,16591,19391,-9930,11560,22356,-22024,7978,-7914,-27673,-22612,7412,-3644,17350,8999,-8875,-9868,335,-7113,5524,30071,-32748,-29009,-6492,23907,-9226,-3726,9722,-17796,3130,-23907,22358,18593,27852,17557,-5820,1573,19383,-11645,-17602,15353,2292,-26416,112,132,3969,2302,-16542,-23781,-4706,-16992,7530,-27601,8233,-22296,-5172,-22442,7227,29576,-15210,-6018,-18507,-19272,-29046,-6833,4645,-5692,10512,9867,4538,-15010,23770,13210,-14079,30404,6438,4040,-15358,-28115,-12239,14858,3426,-28960,27757,-4476,20114,10397,10393,1252,-15152,-15565,31738,-31486,-4517,-29256,-32724,2256,-6256,-21483,2590,4879,-10092,23712,2152,-26781,7184,17852,-24368,-19636,-11810,21144,3542,-28839,-28324,32426,9411,-32345,-31813,-7120,8919,-19138,-4275,-18474,-32640,-14972,25009,-22088,24099,-8911,-12870,-19967,-9764,-24759,25832,-10319,-6445,-5624,-15077,13556,11268,-960,26237,10425,-1040,30857,-2790,-17906,26489,-449,-5659,-2048,16081,24589,3362,-12286,-31373,-9520,12601,22565,-32673,27845,-21839,-16743,-13818,-32404,-11900,-25771,-31403,2444,-16986,30231,-21632,-25790,11159,-30630,24870,-2016,27097,816,-15766,-28377,26582,-16058,6687,14973,23989,-12604,-6479,17385,29920,6797,-2509,9124,2698,-1874,14769,4457,-16396,7035,10395,-15982,-25534,29108,-19365,-2895,-27893,24344,24309,-26137,30281,-11083,-25636,-2595,-26354,20433,22046,-32615,-363,-2830,30253,28359,-2652,26294,-1073,-28562,-15958,401,-27562,-4888,-8837,12571,2314,-10670,-31036,22349,-15188,9468,2443,5659,-31152,29988,5883,-22583,17081,-1359,17985,1465,8755,-14276,-31887,1713,-106,-1744,21739,-24306,6466,-8328,7949,14053,29184,2146,-28666,-23524,-31473,-12300,4066,6977,-14865,7776,-21986,10364,-41,23646,12923,16027,-9391,16822,-2375,-11078,22763,-24810,1132,-8559,-20815,-24308,24807,2494,-14593,-4991,11821,-13237,-31451,-2018,32465,-12099,30310,-10858,-21174,7146,25238,3064,-10169,-3079,20630,-32190,6420,23281,-4702,11581,-12193,-4311,-8797,-24976,17636,-23507,-17941,-1036,7426,11407,-15168,23368,-9818,27300,-6899,4391,28438,32585,-25941,-29306,7409,10256,5221,21307,-8701},
  {7886,5400,-7356,21370,-3653,-11569,-4621,9636,10470,853,9790,-1202,18190,-31366,708,4513,-26155,-7165,-25215,-7793,25492,17004,-20955,-18132,31289,10716,1677,-8826,26300,-18019,17127,-7769,-27918,15988,-24267,31209,-20344,-5393,16153,-18356,8875,-14189,-13945,-14194,29561,-712,-16769,16940,17626,-7036,-18603,-27316,20211,-25845,10544,-25982,23290,-2757,-22019,-29863,29422,-17248,-12329,13308,-32601,-5821,-29626,-23487,-8321,-6750,2094,30668,2135,-11807,-7237,-964,-2336,26323,-26261,4584,-7431,14897,7900,28781,23402,-13861,-12824,-6577,19152,-7113,-9207,-15407,4739,9094,2537,7836,-6679,10280,20275,25998,-11325,29045,-9763,-11135,3629,-7729,-25704,-23384,17324,31868,10170,-29245,19871,-1551,30203,-1869,325,-11176,-25312,-27821,3327,-7645,-11800,-5735,-17962,-7820,-7851,-5810,-10387,14876,-13289,-17198,30871,-23361,-25191,2491,-3747,14277,12165,17160,-30703,21012,6782,-5607,22598,-1487,-32382,-68,-6241,13379,-1906,-6251,32567,2043,31488,18353,-10581,1385,9676,-19467,-28487,-20819,-21304,-23571,1904,-12248,11013,-10104,-4739,12687,-7948,10794,-10036,-13984,-4181,-22976,-9586,-2342,3902,29325,-14911,19020,11404,-347,-14612,-14176,-26143,-30744,-9937,-26066,-10092,-12641,31924,-10070,1765,5528,-15616,-14287,32702,19426,-19166,-24893,15817,2495,-22363,9282,19218,19072,22774,24603,14598,17207,-29507,-7455,30239,25667,-26763,-27502,25492,19532,13714,16873,-31078,-2857,-2878,2202,26046,15925,26645,19352,32630,26093,-17593,-2044,12634,28111,30679,-28203,-2690,-5655,-19476,-25270,-24509,16339,12878,-14871,14174,26195,-32447,-19925,16148,-24790,-8971,25247,-25739,22086,-1103,26223,7912,-20438,14674,-6703,-15833,4797,28464,-3419,6614,8342,-1195,13281,17362,-13674,-11065,-31293,19353,29218,-16773,-17985,7389,-28048,17281,-6385,3763,-28991,-8140,23343,7015,-17659,69,-27248,8145,11040,-26677,-19641,-15250,3727,-2099,25575,-8231,-25500,-12778,7218,-17673,28104,7106,-19146,-16474,-21101,-25398,-16766,-20800,-8173,-18941,-15042,26457,8806,-20054,-6821,12201,3892,-27739,-487,3418,-14385,-9260,-30617,-3116,-11244,-24895,-21290,-27351,-25254,13112,-15115,-27283,-27252,-1566,-7579,-23343,-20317,25468,-32043,-32571,3822,14598,-13855,23039,17165,8199,22520,9246,-514,1415,-29252,20986,28587,20901,29414,-18951,-30932,-17826,20895,8752,15113,-24516,-10334,-6747,-2127,25105,-8745,8550,21195,-3716,-19247,-25334,219,-31551,8595,30595,8058,26740,-20115,-27401,13429,20138,2405,20533,-14752,-28753,-30693,-9326,-10696,-11849,18247,-10590,-19913,5915,26799,14556,-20135,-22623,-6088,-22772,30842,-16261,13248,-22882,14763,32140,2971,8604,-11172,525,32726,12644,11941,5068,-8487,-13351,2833,-13121,-22827,21722,4416,-29603,16886,3175,-4892,23232,5052,28520,9930,-25290,7108,-20582,-5424,24947,-5718,-23877,18637,10490,-18320,-270,19087,-1111,32650,23130,26601,-22830,2727,9800,-17440,16442,-32200,-25846,32567,-21110,-529,-15742,-15852,-28067,18853,-5816,14819,-9912,23264,31973,22886,14616,9386,11236,13554,10658,-5321,-31803,-29286,17649,-4296,-28164,-6167,9004,-17291,29090,7750,-5370,9211,32505,22409,28358,31905,-3670,-14154,22015,1343,-575,-29378,20725,15677,-27293,-2759,18914,3663,12693,23687,20337,5186,-22928,4582,-29958,17757,18213,17465,-29496,-6005,-28464,32509,-10271,-21150,-19199,32159,27599,2081,24356,9724,13922,-3516,-6969,11069,31666,1986,-2924,-15493,18166,28242,28030,-29688,18592,5685,18012,29052,-13933,-27126,12891,-9535,-13843,16582,8493,-32568,-27601,-4281,-16055,21794,31057,29338,19777,7827,3173,-18778,24077,4607,-561,-17958,4275,17012,26441,7672,5759,-4410,15193,-6485,-685,18396,-14144,-30170,27191,32507,27969,8814,16524,-7472,-5662,26921,12265,-1892,-27898,26138,-19874,-14505,31867,-11142,-17906,11907,5032,10374,-7967,164,9712,25101,-12733,-13428,-3830,5406,20105,21358,21502,23418,-6779,24513,-23642,-9921,-10298,28081,12151,4512,-12974,27666,-374,-27550,17075,30987,-8637,-7781,18097,-9154,18677,14314,-25316,-20144,5090,7122,-15185,-1967,-6687,24362,-2514,9135,20268,-29591,20679,20905,29409,-4314,-7654,-9885,31719,-22197,10350,32531,-9776,-11984,1621,-26667,-8979,32026,16285,-19003,2241,32337,-29224,8608,-24918,833,-29614,22107,974,2206,-2878,20265,-11085,-30931,20916,-27717,-19157,12675,-8159,-31566,-16433,-12118,22196,-17976,19616,-21410,11496,-8748,2718,-31959,7058,586,-19017,-1033,-17238,6147,13175,-11981,-24642,-29413,-24174,-30664,-13960,-20666,23560,-17976,-8810,-27989,-29074,26431,-4419,-28441,-16117,-17032,31508,-15737,18018,-17486,-25210,-26090,17551,30323,-31735,23481,-15573,-16380,-7105,3872,26266,-26190,29968,-10493,20389,24301,20169,-23762,-13978,-6627,14384,-16123,-10829,-22682,1851,20166,15417,18501,1681,2967,-18202,-15201,2531,-19288,9044,-10667,24435,26984,-26282,9381,-13299,-30779,13324,15192,-3733,-32570,16608,-21009,20613,-4338,-22616,-19183,4628,-18196,-32400,29168,-18041,-22141,25622,24621,-14019,21253,6756,-13912,-1177,22759,13829,-26932,16113,7419,30558,-845,5420,13805,10060,-2663,-24589,9919,-18750,10997,-11874,-32113,11874,24046,-21062,31519,15505,-19781,-28142,-4559,-655,-12235,29522,-30291,3934,-20987,15447,9401,-27140,8215,-18335,690,-30505,-12163,30286,-17936,13695,-30937,27545,-6346,17505,-25485,-22571,7507,4521,-11357,-19591,21242,-20299,29738,15883,-35,-25571,12797,21170,-13694,18973,18737,14094,-10103,321,21250,-27517,30433,-19484,3987,21604,22449,11094,-14472,-6465,2283,11601},
} ;

static void test_encode_857x1723_impl(long long impl)
{
  unsigned char *s = test_encode_857x1723_s;
  unsigned char *x = test_encode_857x1723_x;
  unsigned char *s2 = test_encode_857x1723_s2;
  unsigned char *x2 = test_encode_857x1723_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857x1723_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857x1723(impl);
    printf("encode_857x1723 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x1723_implementation(impl),ntruprime_dispatch_encode_857x1723_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857x1723;
    printf("encode_857x1723 selected implementation %s compiler %s\n",ntruprime_encode_857x1723_implementation(),ntruprime_encode_857x1723_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857x1723_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857x1723_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857x1723_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857x1723_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857x1723_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857x1723_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857x1723(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x1723")) return;
  storage_encode_857x1723_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857x1723_s = aligned(storage_encode_857x1723_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857x1723_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857x1723_x = aligned(storage_encode_857x1723_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857x1723_s2 = callocplus(maxalloc);
  test_encode_857x1723_s2 = aligned(storage_encode_857x1723_s2,crypto_encode_STRBYTES);
  storage_encode_857x1723_x2 = callocplus(maxalloc);
  test_encode_857x1723_x2 = aligned(storage_encode_857x1723_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857x1723 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857x1723();++impl)
      forked(test_encode_857x1723_impl,impl);
    ++test_encode_857x1723_s;
    ++test_encode_857x1723_x;
    ++test_encode_857x1723_s2;
    ++test_encode_857x1723_x2;
  }
  free(storage_encode_857x1723_x2);
  free(storage_encode_857x1723_s2);
  free(storage_encode_857x1723_x);
  free(storage_encode_857x1723_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

