#!/bin/bash
##: create environment for dpatch testing.
##: the environment is used in the following tests.
##:
##: $TESTDIR/dpatch-test ($PKGPATH) is the debian package directory, 
##: and "dpatch-test" is the package name.

set -e

# create an upstream tarball
mkdir -p "$PKGPATH"
cat <<EOF >$PKGPATH/file1
1. This is file 1
2. which is an example file
3. to test that dpatch works
EOF
cat <<EOF >$PKGPATH/file2
1. This is file 2
2. which is an example file
3. to test that dpatch works
EOF

(
    cd "$TESTDIR" &&\
    tar cfz dpatch-test_0.1.orig.tar.gz dpatch-test/
)

# create Debian directories.
mkdir -p "$PKGPATH/debian/patches/"
touch "$PKGPATH/debian/patches/00list"
cp ../samples/rules/rules.new.dh "$PKGPATH/debian/rules"
chmod a+x "$PKGPATH/debian/rules"
touch "$PKGPATH/Makefile"
cat <<EOF > "$PKGPATH/debian/control"
Source: dpatch-test
Section: devel
Priority: extra
Maintainer: Dpatch Maintainers <dpatch-maintainers@lists.alioth.debian.org>
Standards-Version: 3.6.1

Package: dpatch-test
Architecture: all
Description: testsuite
 This is a package generated by the testsuite
EOF
cat <<EOF > "$PKGPATH/debian/changelog"
dpatch-test (0.1) UNRELEASED; urgency=low

  * this is nothing

 -- nobody <nobody@example.com>  Sat, 18 Jun 2005 22:39:07 +0000
EOF
