#! perl

use strict;
use warnings;

use FindBin ();
use lib "$FindBin::Bin/../lib";

my $configfile = '/etc/apt-cacher/apt-cacher.conf';
my $verbose=1;

# Include the library for the config file parser
require('apt-cacher.pl');
# Read in the config file and set the necessary variables

# $cfg needs to be global for setup_ownership
our $cfg = eval{ read_config($configfile) };

# not sure what to do if we can't read the config file...
die "Could not read configuration file '$configfile': $@" if $@;

private_config();

check_install(); # Before we give up rights

# change uid and gid if root and another user/group configured
if (($cfg->{user} && $cfg->{user} !~ 'root' && !$> )
    || ($cfg->{group} && $cfg->{group} !~ 'root' && !$) =~ /^0/)){
    printmsg("Invoked as root, changing to $cfg->{user}:$cfg->{group} and re-execing.\n");
    setup_ownership($cfg);
    # Rexec to ensure /proc/self/fd ownerships correct which are needed for red
    # patching with pdiffs
    exec($0, @ARGV) or die "Unable to rexec $0: $!\n";
}
# Output data as soon as we print it
local $| = 1;

load_checksum(); # Will disable checksum if BerkeleyDB not available

tie my %db, "BerkeleyDB::Btree",
                       -Filename       => '/var/cache/apt-cacher/sums.db',
                       -Env            => db()->Env
  or die "cannot open database: $BerkeleyDB::Error\n";

sleep 1;
